//=============================================================================
// BulkMessageDisp.js
// ----------------------------------------------------------------------------
// (C)2023 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/03/06 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 文章一括表示
 * @target MZ
 * @author くろあめ
 *
 * @param BulkMessageDisp
 * @text 文章一括表示スイッチ
 * @desc このスイッチがONのとき、文章を一括表示します。デフォルトは5です。
 * @type switch
 * @default 5
 *
 * @param MessageSkipKey
 * @text メッセージスキップキー
 * @desc このキーが押されている間、メッセージが早送りされます。「nosikp」指定で、機能を無効化します。
 * @type select
 * @option shift
 * @value shift
 * @option control
 * @value control
 * @option pageup
 * @value pageup
 * @option pagedown
 * @value pagedown
 * @option tab
 * @value tab
 * @option noskip
 * @value noskip
 * @default shift
 * 
 * @help
 * 指定したスイッチがONの時
 * 制御文字を使わないと、一字ずつ文章を表示するツクールの仕様を無視して
 * 文章の最後まで、一括で表示を行います
 * このスイッチがONの間は、一括表示の制御文字と、ウェイト制御文字は効果を失います。
 *
 * また、指定したキーを押している間
 * 文章を早送りする、スキップ機能を実装します
 * スキップキーに「noskip」を指定すると、スキップ機能を無効化できます。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
*/

(function() {

'use strict';
const script = document.currentScript;
const param = PluginManagerEx.createParameter(script);

    // 文章瞬間表示
    Window_Message.prototype.shouldBreakHere = function(textState) {
        
        if(!$gameSwitches.value(param.BulkMessageDisp) && !this.pressedSkipButton()){
            if (this.canBreakHere(textState)) {
                if (!this._showFast && !this._lineShowFast) {
                    return true;
                }
                if (this.isWaiting()) {
                    return true;
                }
            }
        }
        return false;
    };
    
    // 文章スキップ（待機中）
    Window_Message.prototype.updateInput = function() {
        if (this.isAnySubWindowActive()) {
            return true;
        }
        if (this.pause) {
            if (this.isTriggered() || this.pressedSkipButton()) {
                Input.update();
                this.pause = false;
                if (!this._textState) {
                    this.terminateMessage();
                }
            }
            return true;
        }
        return false;
    };
    
    // 文章スキップ（表示中）
    Window_Message.prototype.onEndOfText = function() {
        if (!this.startInput()) {
            if (!this._pauseSkip && !this.pressedSkipButton()) {
                this.startPause();
            } else {
                this.terminateMessage();
            }
        }
        this._textState = null;
    };
    
    // スキップボタンが押されているか？
    Window_Message.prototype.pressedSkipButton = function() {
        if(param.MessageSkipKey == "noskip") {
            return false;
        }else if(Input.isPressed(param.MessageSkipKey)){
            return true;
        }else{
            return false;
        }
    };
})();